using System;
using System.Data;
using System.Data.SqlClient;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;


[Serializable]
[Microsoft.SqlServer.Server.SqlUserDefinedAggregate(Format.Native, IsInvariantToDuplicates = true, IsInvariantToNulls = true)]
public struct Range
{
    private SqlDouble minValue; // warto minimalna
    private SqlDouble maxValue; // warto maksymalna

    // inicjalizacja
    public void Init()
    {
        // ustaw wartoci null
        this.minValue = SqlDouble.Null;
        this.maxValue = SqlDouble.Null;
    }

    public void Accumulate(SqlDouble Value)
    {
        // sprawd, czy warto najmniejsza zostaa ju okrelona 
        // lub czy jest ona wiksza od przekazanej do funkcji
        // jeli tak to ustaw now warto najmniejsz
        if (this.minValue.IsNull || this.minValue > Value)
            this.minValue = Value;

        // sprawd, czy warto najwiksza zostaa ju okrelona 
        // lub czy jest ona mniejsza od przekazanej do funkcji
        // jeli tak to ustaw now warto najwiksz
        if (this.maxValue.IsNull || this.maxValue < Value)
            this.maxValue = Value;
    }

    public void Merge(Range Group)
    {
        // jeli warto najmniejsza nie zostaa jeszcze okrelona
        // lub jeli zbir Group, z ktrym bd scalane wyniki
        // zawiera warto mniejsza ni aktualnie przechowywana w minValue
        // to ustaw now warto najmniejsz
        if (this.minValue.IsNull || Group.minValue < this.minValue)
            this.minValue = Group.minValue;

        // to samo co powyej dla wartoci najwikszej
        if (this.maxValue.IsNull || Group.maxValue > this.maxValue)
            this.maxValue = Group.maxValue;
    }

    public SqlDouble Terminate()
    {
        // jeli ktra z wartoci ma warto Null to zwr null
        if (this.minValue.IsNull || this.maxValue.IsNull)
            return SqlDouble.Null;
        // w przeciwnym wypadku zwr rnic wartoci najwikszej i najmniejszej w zbiorze
        else
            return this.maxValue - this.minValue;       
    }
}
